/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.abilities;

import com.rwtema.monkmod.MonkManager;
import com.rwtema.monkmod.abilities.MonkAbility;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MonkAbilityMining
extends MonkAbility {
    private final float speed;
    private final Set<String> validTools;
    private final int harvestLevel;

    public MonkAbilityMining(int harvestLevel, float speeds, Set<String> validTools) {
        super("mining");
        this.speed = speeds;
        this.validTools = validTools;
        this.harvestLevel = harvestLevel;
    }

    @SubscribeEvent
    public void onMine(@Nonnull PlayerEvent.BreakSpeed event) {
        if (!MonkManager.getAbilityLevel(event.getEntityPlayer(), this)) {
            return;
        }
        float oldSpeed = Math.min(event.getOriginalSpeed(), 1.0f);
        event.setNewSpeed(Math.max(event.getNewSpeed(), (1.0f + this.speed) * oldSpeed));
    }

    @SubscribeEvent
    public void onHarvest(@Nonnull PlayerEvent.HarvestCheck event) {
        if (!MonkManager.getAbilityLevel(event.getEntityPlayer(), this)) {
            return;
        }
        IBlockState targetBlock = event.getTargetBlock();
        String harvestTool = targetBlock.func_177230_c().getHarvestTool(targetBlock);
        if (harvestTool != null && (this.harvestLevel == 0 && "pickaxe".equals(harvestTool) || !this.validTools.contains(harvestTool))) {
            return;
        }
        if (targetBlock.func_177230_c().getHarvestLevel(targetBlock) <= this.harvestLevel) {
            event.setCanHarvest(true);
        }
    }

    @Override
    @Nonnull
    public String getUnlocalized() {
        return super.getUnlocalized() + "." + this.harvestLevel;
    }

    @Override
    @Nonnull
    protected String[] args() {
        return new String[0];
    }
}

